#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Gyroid_lessVRMod01.fsh     by      byt3_m3chanic
//https://www.shadertoy.com/view/MfKGDG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** 

    License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
    
    Gyroid VR test
    04/16/2024  @byt3_m3chanic
    
    Playing with the VR mode in shadertoy.
    Best using Rift or other PC based system.
    totally chokes the Quest 3 stand-alone.
    
    Anyone know of a good VR browser for Steam? 
    There used to be Supermedium but I don't 
    see that anymore?
*/

#define R        iResolution
#define M        iMouse
#define T        iTime

#define PI  	 3.1415926
#define PI2 	 6.2831853

#define MAX_DIST 40.
#define MIN_DIST 1e-3

float hash21( vec2 p ) { return fract(sin(dot(p,vec2(23.43,84.21))) *4832.3234); }
mat2 rot(float a) { return mat2(cos(a),sin(a),-sin(a),cos(a)); }

//iq of hsv2rgb
vec3 hsv2rgb( in vec3 c ) {
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
	return c.z * mix( vec3(1.0), rgb, c.y);
}

void mouse(inout vec3 ro) {
    float x = M.xy == vec2(0) || M.z < 0. ? -.7  : (M.y/R.y * .5 - .25) * PI2;
    float y = M.xy == vec2(0) || M.z < 0. ? -.25 : (M.x/R.x *.5 - .25) * PI2;
    ro.zy *= rot(x), ro.zx *= rot(y);
}

float sdGry(vec3 p, float s, float t, float b) {
    p *= s;
    float g = abs(dot(sin(p*1.15), cos(p.zxy))-b)/(s*1.15)-t;
    return g*.9;
}

float g1,g2,g4,speed;
vec3 hitPoint;

vec2 map(vec3 p) {    
    vec2 res=vec2(1e5,0.);

    p.z += speed;
    p.y -= .3;

	g1 = sdGry(p, 3.5, .025, .85);
    g2 = sdGry(p, 16.5, .01, .2);
    g4 = sdGry(p, 12.3, .03, .2);

    g1 += (g2 *.75);
    g1 = max(g1,g2);
    g1 -= (g4 *.1);


    if(g1<res.x) res=vec2(g1*.5,1.);

    hitPoint = p;
    return res;
}


vec2 marcher(vec3 ro, vec3 rd) {
    float mat = 0.;
    float depth = 0.;
    for (int i = 0; i<192;i++)
    {
     	vec3 pos = ro + depth * rd;
        vec2 dist = map(pos);
        mat = dist.y;
        if(dist.x<MIN_DIST*depth) break;
        depth += i<42? dist.x*.25 : dist.x*.8; 
        if(depth>MAX_DIST) break;
    }
    return vec2(depth,mat);
}

vec3 normal(vec3 p, float t)
{
    float e = MIN_DIST*t;
    vec2 h =vec2(1,-1)*.5773;
    vec3 n = h.xyy * map(p+h.xyy*e).x+
             h.yyx * map(p+h.yyx*e).x+
             h.yxy * map(p+h.yxy*e).x+
             h.xxx * map(p+h.xxx*e).x;
    return normalize(n);
}

// @Shane @iq Compact self-contained 
// version of IQ's 3D value noise function. 
float n3D(in vec3 p){
	const vec3 s = vec3(113, 157, 1);
	vec3 ip = floor(p); 
    p -= ip; 
    vec4 h = vec4(0., s.yz, s.y + s.z) + dot(ip, s);
    p = p*p*(3. - 2.*p);
    h = mix(fract(sin(h)*43758.543), fract(sin(h + s.x)*43758.543), p.x);
    h.xy = mix(h.xz, h.yw, p.y);
    return mix(h.x, h.y, p.z);
}

vec3 material(vec3 p, vec3 n, float m) {
    vec3 col = vec3(0);

    float clr = min(n3D(hitPoint*247.)*.5,n3D(hitPoint*135.))*n3D(hitPoint*15.);
    
    vec3 lpos = vec3(1.,8,-8.5);
    vec3 l = normalize(lpos-p);

    float diff = clamp(dot(n,l),0.,1.);

    col = vec3(diff*clr)*.1;
    float px = 4./R.x;
    
    float cks = smoothstep(px,-px,g2+.009);
    vec3 h = hsv2rgb(vec3(T*.1+p.z*.125,1.,.5))*1.25;
    if (m==1.) col = mix(col,h,cks);
    return col;
}

vec3 camera(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}
#define O fragColor
#define F fragCoord

//void mainImage( out vec4 O, in vec2 F ) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    speed = T*.1;
    vec2 uv = (2.*F.xy-R.xy)/max(R.x,R.y);
    vec3 col = vec3(0);
    
    vec3 lp = vec3(0);
    vec3 ro = vec3(0,0, -.1);
    mouse(ro);
    
    vec3 rd = camera(uv, ro, lp, 1.);
    vec2 ray = marcher(ro, rd);

    if(ray.x<MAX_DIST) {
    	vec3 p = ro + rd * ray.x;
   		vec3 n = normal(p, ray.x);
        float diff = n.y*.5+.5; 
        col = diff * material(p, n, ray.y);

    }

	col = mix(col, vec3(0.106,0.106,0.153), 1.-exp(-0.005*ray.x*ray.x*ray.x));
 
    col = pow(col, vec3(.4545));
    fragColor = vec4(col,1);


/* VR output
void mainVR( out vec4 O, in vec2 F, in vec3 fragRayOri, in vec3 fragRayDir ) {
    speed = T*.1;
    vec2 uv = (2.*F.xy-R.xy)/max(R.x,R.y);
    vec3 col = vec3(0);
    vec3 ro = fragRayOri;
    vec3 rd = fragRayDir;
    
    vec2 ray = marcher(ro, rd);

    if(ray.x<MAX_DIST) {
    	vec3 p = ro + rd * ray.x;
   		vec3 n = normal(p, ray.x);
        float diff = n.y*.5+.5; 
        if(ray.y==1.){
    	 	col += diff * material(p, n, ray.y);
        } 
    }

	col = mix( col, vec3(.25,.25,.3), 1.-exp(-0.005*ray.x*ray.x*ray.x));

    col = pow(col, vec3(.4545));
    O = vec4(col,1);
}
*/

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

